
rm(list = ls())
library(readxl)
library(dplyr)
library(plyr)
library(lubridate)
library(xtable)
library(ivreg)
library(texreg)
library(car)
library(nleqslv)
library(readxl)
options(scipen=999)

inpath  <- ''

file <- paste0(inpath, 'Base servicios móviles.csv')
base_mercado <- read.csv(file = file, sep = ',')

base_mercado$t <- 3*(base_mercado$TRIMESTRE - 1) + base_mercado$MES_DEL_TRIMESTRE
base_mercado$t[base_mercado$t < 10] <- paste0('0', base_mercado$t[base_mercado$t < 10])
base_mercado$t <- paste(base_mercado$ANNO, base_mercado$t, sep = '-')
base_mercado$SEMESTRE <- ifelse(base_mercado$TRIMESTRE<3,1,2)

d <- base_mercado

d <- ddply(d, .(ANNO, SEMESTRE, TRIMESTRE, MES, t, NOM_COMERCIAL, SERVICIO_PAQUETE), summarize,
         q = sum(lineas),
         vp = sum(valor_facturado))
d <- d %>% filter(!is.na(q), !is.na(vp))
d   <- ddply(d, .(t, SERVICIO_PAQUETE), mutate, M = sum(q))
d   <- d[d$q > 0 & d$vp > 0, ]
d$s <- d$q/d$M
do  <- d

d$j <- as.numeric(as.factor(paste(d$NOM_COMERCIAL, d$SERVICIO_PAQUETE, sep = '-')))

d$p <- d$vp/d$q

d <- d %>% left_join(base_mercado %>% select(ANNO, SEMESTRE, TRIMESTRE, MES, t, NOM_COMERCIAL, SERVICIO_PAQUETE, precio_fijos_mes, nsu))

x  <- ddply(d[d$SERVICIO_PAQUETE == 'Internet móvil', ], .(t, NOM_COMERCIAL), summarize, v = sum(s)*100, m = mean(M))
x  <- ddply(x, .(NOM_COMERCIAL), summarize, m = round(weighted.mean(v, w = m), 4))
f  <- x$NOM_COMERCIAL[x$m >= 4.5]
d1 <- d[d$NOM_COMERCIAL %in% f & d$SERVICIO_PAQUETE == 'Internet móvil', ]
controles_d1 <- base_mercado %>%
  select(ANNO, t, NOM_COMERCIAL, SERVICIO_PAQUETE, pospago, banda_ancha, traf_int_pos, ing_gb, gb_acceso, precio_int_fijo, precio_fijos)
d1 <- d1 %>%
  left_join(controles_d1)

DATA <- d1

DATA <- ddply(DATA, .(t), mutate, so = 1 - sum(s))
DATA$delta <- log(DATA$s) - log(DATA$so)

m0 <- ivreg(delta ~ p + NOM_COMERCIAL + t + pospago + banda_ancha + traf_int_pos + ing_gb + gb_acceso, data = DATA)
summary(m0)

empresa <- c("Tigo", "Movistar", "Comcel", "WOM")

observado <- DATA %>%
  filter(t==max(t)) %>%
  mutate(orden = ifelse(NOM_COMERCIAL=="Tigo", 1,
                        ifelse(NOM_COMERCIAL=="Movistar", 2,
                               ifelse(NOM_COMERCIAL=="Claro",3,NA)))) %>%
  arrange(orden) %>%
  mutate(int = 1, t = 1,
         d_Tigo = ifelse(NOM_COMERCIAL=="Tigo",1,0),
         d_Movistar = ifelse(NOM_COMERCIAL=="Movistar",1,0),
         d_WOM = ifelse(NOM_COMERCIAL=="WOM",1,0))

n_obs<- as.numeric(nrow(observado))

caracteristicas_obs <- as.matrix(select(observado, pospago, banda_ancha, traf_int_pos, int, t, d_Tigo, d_Movistar, d_WOM))
precios_obs <- as.matrix(select(observado, p))
participaciones_obs <- as.matrix(select(observado, s))

caracteristicas_integracion <- caracteristicas_obs
caracteristicas_integracion[1,1] <- (caracteristicas_obs[1,1]+caracteristicas_obs[2,1])/2
caracteristicas_integracion[2,1] <- (caracteristicas_obs[1,1]+caracteristicas_obs[2,1])/2
caracteristicas_integracion[1,2] <- (caracteristicas_obs[1,2]+caracteristicas_obs[2,2])/2
caracteristicas_integracion[2,2] <- (caracteristicas_obs[1,2]+caracteristicas_obs[2,2])/2
caracteristicas_integracion[1,3] <- (caracteristicas_obs[1,3]+caracteristicas_obs[2,3])/2
caracteristicas_integracion[2,3] <- (caracteristicas_obs[1,3]+caracteristicas_obs[2,3])/2
caracteristicas_integracion[2,7] <- 1
caracteristicas_integracion[2,8] <- 0

summary(m0)

alpha_est <- 0.013370

beta_est <- c(-1.529307, -5.773604, -6.305096, 13.483478, 0.875353, -2.703275, 0.208425, -1.505889)

f_elasticidades <- function(alpha, sharesobs, precios){
  N <- as.numeric(nrow(precios))
  r_elasticidad <- matrix(data=NA, ncol=N, nrow=N)
  for(i in 1:N){
    for(j in 1:N){
      r_elasticidad[i,j] <- (alpha*precios[j])*sharesobs[j]
    }
  }
  diag(r_elasticidad) <- -alpha*precios*(1-sharesobs)
  return(r_elasticidad)
}

f_costosm_equilibrio <- function(elasticidades, precios){
  N <- as.numeric(nrow(precios))
  r_costos <- (1+1/diag(elasticidades))*precios
  colnames(r_costos) <- c("Costos estimados")
  return(r_costos)
}

f_participaciones_est <- function(alpha, beta, caracteristicas, precios){
  N <- as.numeric(nrow(precios))
  V <- matrix(data=NA, ncol=1, nrow=N)
  for(j in 1:N){
    V[j,1] <- exp(as.numeric(caracteristicas[j,]%*%beta)-as.numeric(alpha*precios[j,1]))
  }
  r_participaciones <- matrix(data=NA, ncol=1, nrow=N)
  denominador <- 1+sum(V)
  r_participaciones <- (1/denominador)*V
  return(r_participaciones)
}

f_condiciones_eq <- function(input){
  N <- n_obs
  precios_input <- input[1:N]
  participaciones_input <- input[(N+1):(2*N)]
  c_integradas <- c()
  c_integradas[1] <- 1+((precios_input[1]-as.numeric(costos_est[1,1])))*(-alpha_est*(1-participaciones_input[1]))+
    (precios_input[2]-as.numeric(costos_est[2,1]))*(alpha_est*participaciones_input[2])
  c_integradas[2] <-1+((precios_input[2]-as.numeric(costos_est[2,1])))*(-alpha_est*(1-participaciones_input[2]))+
    (precios_input[1]-as.numeric(costos_est[1,1]))*(alpha_est*participaciones_input[1])
  c_competidores <- costos_est-precios_input*(1-1/(alpha_est*(1-participaciones_input)*precios_input))
  c_competidores <- c_competidores[-c(1:2),]
  c_participaciones <- participaciones_input-f_participaciones_est(alpha=alpha_est,
                                                                   beta=beta_est,
                                                                   caracteristicas = caracteristicas_integracion,
                                                                   precios=as.matrix(precios_input))

  ajuste <- rbind(as.matrix(c_integradas),as.matrix(c_competidores), as.matrix(c_participaciones))
  return(ajuste)
}

f_condiciones_eq_coordinado <- function(input){
  N <- n_obs
  precios_input <- input[1:N]
  participaciones_input <- input[(N+1):(2*N)]
  c_integradas <- c()
  c_integradas[1] <- 1+((precios_input[1]-as.numeric(costos_est[1,1])))*(-alpha_est*(1-participaciones_input[1]))+
    (precios_input[2]-as.numeric(costos_est[2,1]))*(alpha_est*participaciones_input[2])+
    (precios_input[3]-as.numeric(costos_est[3,1]))*(alpha_est*participaciones_input[3])
  c_integradas[2] <-1+((precios_input[2]-as.numeric(costos_est[2,1])))*(-alpha_est*(1-participaciones_input[2]))+
    (precios_input[1]-as.numeric(costos_est[1,1]))*(alpha_est*participaciones_input[1])+
    (precios_input[3]-as.numeric(costos_est[3,1]))*(alpha_est*participaciones_input[3])
  c_integradas[3] <-1+((precios_input[3]-as.numeric(costos_est[3,1])))*(-alpha_est*(1-participaciones_input[3]))+
    (precios_input[1]-as.numeric(costos_est[1,1]))*(alpha_est*participaciones_input[1])+
    (precios_input[2]-as.numeric(costos_est[2,1]))*(alpha_est*participaciones_input[2])
  c_competidores <- costos_est-precios_input*(1-1/(alpha_est*(1-participaciones_input)*precios_input))
  c_competidores <- c_competidores[-c(1:3),]
  c_participaciones <- participaciones_input-f_participaciones_est(alpha=alpha_est,
                                                                   beta=beta_est,
                                                                   caracteristicas = caracteristicas_integracion,
                                                                   precios=as.matrix(precios_input))

  ajuste <- rbind(as.matrix(c_integradas),as.matrix(c_competidores), as.matrix(c_participaciones))
  return(ajuste)
}

f_beneficios <- function(precios, costos, shares){
  beneficios <- (precios-costos)*shares
  colnames(beneficios) <- c("Beneficios")
  return(beneficios)
}

precio_mercado_obs <- as.numeric(precios_obs[,1]%*%participaciones_obs[,1])
precio_mercado_obs

elas_est<- f_elasticidades(alpha=alpha_est, sharesobs=participaciones_obs, precios=precios_obs)
elas_est

participaciones_est <- f_participaciones_est(alpha=alpha_est, beta=beta_est, caracteristicas = caracteristicas_obs, precios=precios_obs)
participaciones_est

costos_est <- f_costosm_equilibrio(elasticidades = elas_est, precios=precios_obs)
rownames(costos_est) <- empresa
costos_est
